﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Raport rotacji</TITLE>
		<script runat="server">
		
            public class ParametryContext : ContextBase, IPreValidate {
                public ParametryContext (Context cx)
                    : base(cx) {
                }

                FromTo _okres = FromTo.Empty;

                [Context(Required=false)]
                public FromTo Okres {
                    get { 
                        if(_okres == FromTo.Empty)
                            return FromTo.Month(Date.Today.Year, Date.Today.Month);
                        return _okres; }
                    set {
                        _okres = value;
                    }
                }

                bool IPreValidate.PreValidate () {
                    return false; //_okres != FromTo.Empty;
                }
            }

            static ParametryContext _parametry;

            [Context]
            public ParametryContext Parametry {
                get { return _parametry; }
                set { _parametry = value; }
            }            

            		         
            void OnContextLoad (Object sender, EventArgs args) {
                Magazyn[] magazyny = null;
                
                ObrotyParams op = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
                if (op != null)
                {
                    checkMagazyny(op.Magazyny);
                    magazyny = op.Magazyny;
                }
                else
                {
                    Magazyn[] mg = dc.Context[typeof(Magazyn[]), false] as Magazyn[];
                    if (mg != null)
                    {
                        checkMagazyny(mg);
                        magazyny = mg;
                    }
                }
                
                
                dc.Context.Set( magazyny );  
                // Usuwam z kontekstu magazyn aby Worker ObrotyTowaruWorker liczył się dla magazynów a nie jednego magazynu ... TID:  17051;              
                dc.Context.Remove(typeof(Magazyn));                          
                Parametry.Context[typeof(FromTo)] = Parametry.Okres;
                Grid.DataSource = (Towar[])dc[typeof(Towar[])];
                ReportHeader.Title += String.Format("Magazyn: {0}| Okres: {1}", WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(magazyny), Parametry.Okres);
            }

            private void checkMagazyny(Magazyn[] mags) {
                if (mags == null || (mags != null && mags.Length == 0))
                    throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
            }
    
            
            protected void Grid_BeforeRow (object sender, RowEventArgs args) {
                Towar t = (Towar)args.Row;
                args.VisibleRow = t.Typ == TypTowaru.Towar || t.Typ == TypTowaru.Produkt;
                if (!args.VisibleRow)
                    return;
                decimal d = (decimal)wsk.EditValue;
                if (d == 999999999.99m)
                    wsk.Format = "brak";
                else
                    wsk.Format = string.Empty;
                d = (decimal)wskDni.EditValue;
                if (d == 999999999.99m)
                    wskDni.Format = "brak";
                else
                    wskDni.Format = string.Empty;
            }
</script>		
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Raport rotacji|"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" Caption="Kod" Width="20" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwa" Caption="Nazwa" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn id="wsk" runat="server" Align="Right" DataMember="Workers.ObrotyTowaru.WskaźnikRotacji" Caption="Ile razy w okresie są|odnawiane zapasy" Width="18" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn id="wskDni" runat="server" Align="Right" DataMember="Workers.ObrotyTowaru.WskaźnikRotacjiWDniach" Caption="Co ile dni są|odnawiane zapasy" Width="18" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

